using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{


	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/30/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///UI dialog allowing users to verify new label attached to a modified blood unit
	///</summary>

	#endregion


	public class DlgVerifyModifiedUnit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		/// <summary>
		/// Blood unit to be verified
		/// </summary>
		private BOL.BloodUnit _verifyBloodUnit;
		/// <summary>
		/// Blood unit to verify
		/// </summary>
		private BOL.BloodUnit _labelBloodUnit;
		//
		private MultipleBloodProductCode _multipleBloodProductCode;
		//
		private ArrayList _labelMismatchExceptions;
		//
		private BOL.ModifiedUnit _modifiedUnit;

		private bool _okProductCode = false;
		private bool _okAboRh = false;
		private bool _okExpirationDate = false;
		#endregion


		#region FormControls

		private System.Windows.Forms.GroupBox grpInstructions;
		private System.Windows.Forms.Label lblInstructions;
		private System.Windows.Forms.GroupBox grpUnit;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private gov.va.med.vbecs.GUI.controls.AboRHComboBox cmbABORh;
		private gov.va.med.vbecs.GUI.controls.UnitIDTextbox txtBloodUnitID;
		private gov.va.med.vbecs.GUI.controls.ProductCodeTextbox txtProductCode;
		private System.Windows.Forms.PictureBox pictureBox6;
		private System.Windows.Forms.PictureBox pictureBox3;
		private System.Windows.Forms.PictureBox pictureBox7;
		private System.Windows.Forms.Label lblProductCode;
		private System.Windows.Forms.Label lblExpiration;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.Label lblUnitIDEdit;
		private gov.va.med.vbecs.GUI.controls.ExpirationDateComboBox dtpExpirationDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel newBloodUnitLabel1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label lblSkipInstruction;
		private System.Windows.Forms.Label label2;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnCancel;
		private System.Windows.Forms.TextBox txtComment;
		
		#endregion


		private System.ComponentModel.IContainer components = null;

		#region Constructors/Destructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// DlgVerifyModifiedUnit constructor, accepts unit to be verified
		/// </summary>
		/// <param name="modifiedUnit"></param>
		/// <param name="bumControl"></param>
		/// <param name="unitIndex"></param>
		public DlgVerifyModifiedUnit(BOL.ModifiedUnit modifiedUnit, BOL.BloodUnitModification bumControl, int unitIndex)
		{
			InitializeComponent();
			//
			if (bumControl.IsPool)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgVerifyModifiedUnit());
			}
			else if (bumControl.IsSplit)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgVerifyModifiedUnit());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgVerifyModifiedUnit());
			}

			//
			this._modifiedUnit = modifiedUnit;
			this.SetComponentProperties();
			this._verifyBloodUnit = modifiedUnit.NewUnit;
			this.txtProductCode.Tag = System.Guid.Empty;

			this._labelBloodUnit = new BOL.BloodUnit(System.Guid.NewGuid());			
			this._labelBloodUnit.BarcodeType = this._verifyBloodUnit.BarcodeType;
			this._labelBloodUnit.LocalSupplier = this._verifyBloodUnit.LocalSupplier;
			this._labelBloodUnit.DonationType = this._verifyBloodUnit.DonationType;

			//07/25/2005
			this._labelBloodUnit.SetLabelUnitId(this._verifyBloodUnit.LabelUnitId, false);
			this._labelBloodUnit.SetEyeReadableUnitId(this._verifyBloodUnit.EyeReadableUnitId, false);

			//Adding more fields that might be needed for label printing ----
			this._labelBloodUnit.BloodUnitStatus.BiohazardousWarningIndicator = this._verifyBloodUnit.BloodUnitStatus.BiohazardousWarningIndicator;
			this._labelBloodUnit.BloodUnitStatus.QuarantineIndicator = this._verifyBloodUnit.BloodUnitStatus.QuarantineIndicator;
			this._labelBloodUnit.LocalSupplier = this._verifyBloodUnit.LocalSupplier;
			this._labelBloodUnit.UnitFdaRegistrationNumber = this._verifyBloodUnit.UnitFdaRegistrationNumber;

			this.newBloodUnitLabel1.BloodUnit = this._labelBloodUnit;
			this.newBloodUnitLabel1.Refresh();
			this._labelMismatchExceptions = new ArrayList();

			if (unitIndex > 0)
			{
				this.Text = string.Concat(this.Text, " - Target Unit ", unitIndex.ToString());
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgVerifyModifiedUnit));
			this.grpInstructions = new System.Windows.Forms.GroupBox();
			this.lblSkipInstruction = new System.Windows.Forms.Label();
			this.lblInstructions = new System.Windows.Forms.Label();
			this.grpUnit = new System.Windows.Forms.GroupBox();
			this.dtpExpirationDate = new gov.va.med.vbecs.GUI.controls.ExpirationDateComboBox(this.components);
			this.cmbABORh = new gov.va.med.vbecs.GUI.controls.AboRHComboBox(this.components);
			this.txtBloodUnitID = new gov.va.med.vbecs.GUI.controls.UnitIDTextbox(this.components);
			this.txtProductCode = new gov.va.med.vbecs.GUI.controls.ProductCodeTextbox(this.components);
			this.pictureBox6 = new System.Windows.Forms.PictureBox();
			this.pictureBox3 = new System.Windows.Forms.PictureBox();
			this.pictureBox7 = new System.Windows.Forms.PictureBox();
			this.lblProductCode = new System.Windows.Forms.Label();
			this.lblExpiration = new System.Windows.Forms.Label();
			this.lblABORh = new System.Windows.Forms.Label();
			this.lblUnitIDEdit = new System.Windows.Forms.Label();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.newBloodUnitLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.btnCancel = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpInstructions.SuspendLayout();
			this.grpUnit.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(604, 30);
			this.vbecsLogo1.TabIndex = 6;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 313);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 8;
			// 
			// grpInstructions
			// 
			this.grpInstructions.AccessibleDescription = "Please verify the labeling of the modified product. Barcode data entry is preferr" +
				"ed. If no barcode is available, manual data entry is acceptable. To skip label v" +
				"erification, a comment is required.";
			this.grpInstructions.AccessibleName = "Please verify the labeling of the modified product. Barcode data entry is preferr" +
				"ed. If no barcode is available, manual data entry is acceptable. To skip label v" +
				"erification, a comment is required.";
			this.grpInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInstructions.Controls.Add(this.lblSkipInstruction);
			this.grpInstructions.Controls.Add(this.lblInstructions);
			this.grpInstructions.Location = new System.Drawing.Point(56, 36);
			this.grpInstructions.Name = "grpInstructions";
			this.grpInstructions.Size = new System.Drawing.Size(280, 80);
			this.grpInstructions.TabIndex = 0;
			this.grpInstructions.TabStop = false;
			// 
			// lblSkipInstruction
			// 
			this.lblSkipInstruction.AccessibleDescription = "";
			this.lblSkipInstruction.AccessibleName = "";
			this.lblSkipInstruction.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblSkipInstruction.Location = new System.Drawing.Point(8, 60);
			this.lblSkipInstruction.Name = "lblSkipInstruction";
			this.lblSkipInstruction.Size = new System.Drawing.Size(268, 16);
			this.lblSkipInstruction.TabIndex = 1;
			this.lblSkipInstruction.Text = "To skip label verification, a comment is required.";
			// 
			// lblInstructions
			// 
			this.lblInstructions.AccessibleDescription = "";
			this.lblInstructions.AccessibleName = "";
			this.lblInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblInstructions.Location = new System.Drawing.Point(8, 12);
			this.lblInstructions.Name = "lblInstructions";
			this.lblInstructions.Size = new System.Drawing.Size(264, 44);
			this.lblInstructions.TabIndex = 0;
			this.lblInstructions.Text = "Please verify the labeling of the modified product. Barcode data entry is preferr" +
				"ed. If no barcode is available, manual data entry is acceptable. ";
			// 
			// grpUnit
			// 
			this.grpUnit.AccessibleDescription = "Please verify the labeling of the modified product. Barcode data entry is preferr" +
				"ed. If no barcode is available, manual data entry is acceptable. To skip label v" +
				"erification, a comment is required.";
			this.grpUnit.AccessibleName = "Please verify the labeling of the modified product. Barcode data entry is preferr" +
				"ed. If no barcode is available, manual data entry is acceptable.To skip label ve" +
				"rification, a comment is required.";
			this.grpUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUnit.Controls.Add(this.dtpExpirationDate);
			this.grpUnit.Controls.Add(this.cmbABORh);
			this.grpUnit.Controls.Add(this.txtBloodUnitID);
			this.grpUnit.Controls.Add(this.txtProductCode);
			this.grpUnit.Controls.Add(this.pictureBox6);
			this.grpUnit.Controls.Add(this.pictureBox3);
			this.grpUnit.Controls.Add(this.pictureBox7);
			this.grpUnit.Controls.Add(this.lblProductCode);
			this.grpUnit.Controls.Add(this.lblExpiration);
			this.grpUnit.Controls.Add(this.lblABORh);
			this.grpUnit.Controls.Add(this.lblUnitIDEdit);
			this.grpUnit.Location = new System.Drawing.Point(56, 116);
			this.grpUnit.Name = "grpUnit";
			this.grpUnit.Size = new System.Drawing.Size(280, 128);
			this.grpUnit.TabIndex = 1;
			this.grpUnit.TabStop = false;
			// 
			// dtpExpirationDate
			// 
			this.dtpExpirationDate.AccessibleDescription = "Expiration Date";
			this.dtpExpirationDate.AccessibleName = "Expiration Date";
			this.dtpExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpExpirationDate.Barcode = false;
			this.dtpExpirationDate.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.dtpExpirationDate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpExpirationDate.IsbtBarcodeDate = "";
			this.dtpExpirationDate.Location = new System.Drawing.Point(116, 100);
			this.dtpExpirationDate.MaxDate = new System.DateTime(9998, 12, 31, 0, 0, 0, 0);
			this.dtpExpirationDate.MinDate = new System.DateTime(1753, 1, 1, 0, 0, 0, 0);
			this.dtpExpirationDate.Name = "dtpExpirationDate";
			this.dtpExpirationDate.Size = new System.Drawing.Size(144, 20);
			this.dtpExpirationDate.TabIndex = 7;
			this.dtpExpirationDate.Value = new System.DateTime(1974, 4, 20, 16, 1, 11, 28);
			this.dtpExpirationDate.Leave += new System.EventHandler(this.dtpExpirationDate_Leave);
			// 
			// cmbABORh
			// 
			this.cmbABORh.AccessibleDescription = "A B O R H";
			this.cmbABORh.AccessibleName = "A B O R H";
			this.cmbABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbABORh.Barcode = false;
			this.cmbABORh.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.cmbABORh.DonationTypeId = -1;
			this.cmbABORh.Interval = 500;
			this.cmbABORh.Location = new System.Drawing.Point(116, 72);
			this.cmbABORh.Name = "cmbABORh";
			this.cmbABORh.Size = new System.Drawing.Size(144, 22);
			this.cmbABORh.TabIndex = 5;
			this.cmbABORh.Leave += new System.EventHandler(this.cmbABORh_Leave);
			// 
			// txtBloodUnitID
			// 
			this.txtBloodUnitID.AccessibleDescription = "Unit I D";
			this.txtBloodUnitID.AccessibleName = "Unit I D";
			this.txtBloodUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtBloodUnitID.Barcode = false;
			this.txtBloodUnitID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtBloodUnitID.Location = new System.Drawing.Point(116, 16);
			this.txtBloodUnitID.MaxLength = 15;
			this.txtBloodUnitID.Name = "txtBloodUnitID";
			this.txtBloodUnitID.ReadOnly = true;
			this.txtBloodUnitID.Size = new System.Drawing.Size(144, 20);
			this.txtBloodUnitID.TabIndex = 1;
			this.txtBloodUnitID.Text = "";
			// 
			// txtProductCode
			// 
			this.txtProductCode.AccessibleDescription = "Product Code";
			this.txtProductCode.AccessibleName = "Product Code";
			this.txtProductCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProductCode.Barcode = false;
			this.txtProductCode.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtProductCode.Location = new System.Drawing.Point(116, 44);
			this.txtProductCode.MaxLength = 10;
			this.txtProductCode.Name = "txtProductCode";
			this.txtProductCode.RecursionGuard = false;
			this.txtProductCode.Size = new System.Drawing.Size(144, 20);
			this.txtProductCode.TabIndex = 3;
			this.txtProductCode.Text = "";
			this.txtProductCode.Leave += new System.EventHandler(this.txtProductCode_Leave);
			// 
			// pictureBox6
			// 
			this.pictureBox6.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox6.Image")));
			this.pictureBox6.Location = new System.Drawing.Point(12, 104);
			this.pictureBox6.Name = "pictureBox6";
			this.pictureBox6.Size = new System.Drawing.Size(20, 20);
			this.pictureBox6.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox6.TabIndex = 67;
			this.pictureBox6.TabStop = false;
			// 
			// pictureBox3
			// 
			this.pictureBox3.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox3.Image")));
			this.pictureBox3.Location = new System.Drawing.Point(12, 76);
			this.pictureBox3.Name = "pictureBox3";
			this.pictureBox3.Size = new System.Drawing.Size(20, 20);
			this.pictureBox3.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox3.TabIndex = 65;
			this.pictureBox3.TabStop = false;
			// 
			// pictureBox7
			// 
			this.pictureBox7.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox7.Image")));
			this.pictureBox7.Location = new System.Drawing.Point(12, 48);
			this.pictureBox7.Name = "pictureBox7";
			this.pictureBox7.Size = new System.Drawing.Size(20, 20);
			this.pictureBox7.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox7.TabIndex = 64;
			this.pictureBox7.TabStop = false;
			// 
			// lblProductCode
			// 
			this.lblProductCode.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblProductCode.Location = new System.Drawing.Point(32, 48);
			this.lblProductCode.Name = "lblProductCode";
			this.lblProductCode.Size = new System.Drawing.Size(84, 16);
			this.lblProductCode.TabIndex = 2;
			this.lblProductCode.Text = "Product Code*";
			// 
			// lblExpiration
			// 
			this.lblExpiration.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblExpiration.Location = new System.Drawing.Point(32, 104);
			this.lblExpiration.Name = "lblExpiration";
			this.lblExpiration.Size = new System.Drawing.Size(88, 16);
			this.lblExpiration.TabIndex = 6;
			this.lblExpiration.Text = "Expiration Date*";
			// 
			// lblABORh
			// 
			this.lblABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblABORh.Location = new System.Drawing.Point(32, 76);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(84, 16);
			this.lblABORh.TabIndex = 4;
			this.lblABORh.Text = "ABO/Rh*";
			// 
			// lblUnitIDEdit
			// 
			this.lblUnitIDEdit.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblUnitIDEdit.Location = new System.Drawing.Point(32, 20);
			this.lblUnitIDEdit.Name = "lblUnitIDEdit";
			this.lblUnitIDEdit.Size = new System.Drawing.Size(84, 16);
			this.lblUnitIDEdit.TabIndex = 0;
			this.lblUnitIDEdit.Text = "Unit ID";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(48, 256);
			this.grpImage.TabIndex = 7;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(40, 40);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 38;
			this.pictureBox1.TabStop = false;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(444, 300);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 4;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// newBloodUnitLabel1
			// 
			this.newBloodUnitLabel1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.newBloodUnitLabel1.BackColor = System.Drawing.Color.WhiteSmoke;
			this.newBloodUnitLabel1.BloodUnit = null;
			this.newBloodUnitLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.newBloodUnitLabel1.Location = new System.Drawing.Point(344, 40);
			this.newBloodUnitLabel1.Name = "newBloodUnitLabel1";
			this.newBloodUnitLabel1.Size = new System.Drawing.Size(257, 204);
			this.newBloodUnitLabel1.TabIndex = 2;
			this.newBloodUnitLabel1.TabStop = false;
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.txtComment);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Location = new System.Drawing.Point(56, 252);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(544, 40);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			// 
			// txtComment
			// 
			this.txtComment.AccessibleDescription = "Comment";
			this.txtComment.AccessibleName = "Comment";
			this.txtComment.Location = new System.Drawing.Point(112, 12);
			this.txtComment.MaxLength = 255;
			this.txtComment.Name = "txtComment";
			this.txtComment.Size = new System.Drawing.Size(412, 20);
			this.txtComment.TabIndex = 1;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(32, 16);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(76, 16);
			this.label2.TabIndex = 0;
			this.label2.Text = "Comment";
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.EnabledButton = false;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(524, 300);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(75, 23);
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// DlgVerifyModifiedUnit
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(604, 329);
			this.ControlBox = false;
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpUnit);
			this.Controls.Add(this.grpInstructions);
			this.Controls.Add(this.newBloodUnitLabel1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.Name = "DlgVerifyModifiedUnit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Verify Printed Label";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgVerifyModifiedUnit_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.newBloodUnitLabel1, 0);
			this.Controls.SetChildIndex(this.grpInstructions, 0);
			this.Controls.SetChildIndex(this.grpUnit, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpInstructions.ResumeLayout(false);
			this.grpUnit.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Gets comment entered by user to justify not verifying blood unit
		/// </summary>
		public string Comment
		{
			get
			{
				return this.txtComment.Text;
			}
		}

		/// <summary>
		/// Get the list of label mismatch exceptions
		/// </summary>
		public ArrayList LabelMismatchExceptions
		{
			get
			{
				return this._labelMismatchExceptions;
			}
		}

		#endregion

		#region Methods/Functions

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to enable OK button based on user input and error provider messages
		/// </summary>
		private void CheckValid()
		{
			bool enableButton = false;
			bool showMessageBox = (!this.btnOK.EnabledButton);		//Trying not to show the message more than once
			this.newBloodUnitLabel1.Refresh();

			if (	(this.txtProductCode.Text.Trim().Length > 0) && (this.errError.GetError(this.txtProductCode).Length == 0 && this._okProductCode)
				&&  (this.cmbABORh.SelectedIndex >= 0) && (this.errError.GetError(this.cmbABORh).Length == 0 && this._okAboRh)
				&&  (this.DatesMatch(this._labelBloodUnit.BloodUnitMedia.UnitExpirationDate, this._verifyBloodUnit.BloodUnitMedia.UnitExpirationDate)) && (this.errError.GetError(this.dtpExpirationDate).Length == 0) && this._okExpirationDate)
				enableButton = true;

			this.btnOK.EnabledButton = enableButton;
			
			if (enableButton)
			{
				if (showMessageBox)
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.LabelVerificationComplete());
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC026.OKToSave().ResString);
			}
			else
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC026.VerifyLabel().ResString);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Verify Printed Label";
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			this.btnCancel.EnabledButton = false;
			this.btnCancel.Text = "&Cancel";
			
			this.cmbABORh.Interval = 100;

			this.btnCancel.SetToolTip(Common.StrRes.Tooltips.UC026.EnterAComment().ResString);
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC026.VerifyLabel().ResString);

			this.dtpExpirationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpExpirationDate.ClearDateText();

			this.txtBloodUnitID.Text = this._modifiedUnit.NewUnit.EyeReadableUnitId;
		}

		/// <summary>
		/// Loads blood product properties based on given product code.
		/// </summary>
		/// <param name="productCode"></param>
		private void GetBloodProduct(string productCode)
		{
			this._okProductCode = false;
			this.txtProductCode.Tag = System.Guid.Empty;

			this.Working();
			_multipleBloodProductCode = new MultipleBloodProductCode(ThisUser, this, productCode, true);

			switch(_multipleBloodProductCode.BloodProductsDataTable.Rows.Count)
			{
				case 0:
					this.Stopped();
					//This will get sent back to populate the errorProvider
					throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("Product Code").ResString);

				default:
					this._okProductCode = true;
					this.txtProductCode.Tag = _multipleBloodProductCode.BloodProduct.BloodProductGuid;
					break;
			}
			this.Ready();		
		}

		/// <summary>
		/// Generates exception if there is a discrepancy
		/// </summary>
		/// <param name="cancel"></param>
		private void GenerateExceptions(bool cancel)
		{
			BOL.AboRh aboRH = new BOL.AboRh(this.cmbABORh.Abo, this.cmbABORh.RH);
			string tmpValue = string.Empty;

			if (this._verifyBloodUnit.BloodProductGuid != (System.Guid)this.txtProductCode.Tag || cancel)
			{
				BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Target_product_label_mismatch, this.txtComment.Text, Common.LogonUser.LogonUserName);
				exRep.GenerateExceptionLabelMismatch(this._verifyBloodUnit, this._modifiedUnit.ProductModificationCode.ToString(), Common.LogonUser.LogonUserName, this._modifiedUnit.ModificationDateTime, this._verifyBloodUnit.ProductCode, this.txtProductCode.Text.Trim());
				this._labelMismatchExceptions.Add(exRep);
			}

			if (this._verifyBloodUnit.BloodUnitMedia.AboRh.AboRHText != aboRH.AboRHText || cancel)
			{
				tmpValue = (this.cmbABORh.Text == string.Empty) ? string.Empty : aboRH.AboRHText;
				BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Target_product_label_mismatch, this.txtComment.Text, Common.LogonUser.LogonUserName);
				exRep.GenerateExceptionLabelMismatch(this._verifyBloodUnit, this._modifiedUnit.ProductModificationCode.ToString(), Common.LogonUser.LogonUserName, this._modifiedUnit.ModificationDateTime, this._verifyBloodUnit.BloodUnitMedia.AboRh.AboRHText, tmpValue);
				this._labelMismatchExceptions.Add(exRep);
			}

			if (!this.DatesMatch(this._verifyBloodUnit.BloodUnitMedia.UnitExpirationDate, this.dtpExpirationDate.Value) || cancel)
			{
				tmpValue = (this.dtpExpirationDate.VisibleText == string.Empty) ? string.Empty : this.dtpExpirationDate.Value.ToString();
				BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Target_product_label_mismatch, this.txtComment.Text, Common.LogonUser.LogonUserName);
				exRep.GenerateExceptionLabelMismatch(this._verifyBloodUnit, this._modifiedUnit.ProductModificationCode.ToString(), Common.LogonUser.LogonUserName, this._modifiedUnit.ModificationDateTime, this._verifyBloodUnit.BloodUnitMedia.UnitExpirationDate.ToString(), tmpValue);
				this._labelMismatchExceptions.Add(exRep);
			}

		}

		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Product code text box leave event handler, verifies entry against VerifyBloodUnit
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void txtProductCode_Leave(object sender, System.EventArgs e)
		{
			try
			{
				//Format the product code to upper case
				if (this.txtProductCode.Text.Length > 1)
				{
					string firstChar = this.txtProductCode.Text.Substring(0,1).ToUpper();
					string remain = this.txtProductCode.Text.Substring(1);
					this.txtProductCode.Text = firstChar + remain;
				}

				if (this.txtProductCode.Text.Trim() == string.Empty)
				{
					this._okAboRh = false;
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementNotEntered("Product Code"));
				}
				else
				{
					this.GetBloodProduct(this.txtProductCode.Text);
					System.Guid selectedBP = (System.Guid)this.txtProductCode.Tag;

					//If they've selected teh same thing they've already got, leave it alone
					if (selectedBP == this._verifyBloodUnit.BloodProductGuid)
					{
						if ((this._verifyBloodUnit.BarcodeType == Common.BarcodeType.ISBT128 && this.txtProductCode.Text.Length != 8) ||
							(this._verifyBloodUnit.BarcodeType == Common.BarcodeType.Codabar && this.txtProductCode.Text.Length != 5))
						{
							throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("Product Code").ResString);
						}
						else
						{
							if (this._verifyBloodUnit.BarcodeType == Common.BarcodeType.ISBT128)
							{
								if (this._verifyBloodUnit.UnitDivisionId == this.txtProductCode.Text.Substring(6,2) && this._verifyBloodUnit.DonationType.DonationTypeCode.ToString() == this.txtProductCode.Text.Substring(5,1))
								{
									this._labelBloodUnit.BloodProductGuid = selectedBP;
									this._labelBloodUnit.ProductCode = this.txtProductCode.Text;
									this._labelBloodUnit.ProductShortName = this._verifyBloodUnit.ProductShortName;
									this.errError.SetVbecsError(this.txtProductCode, string.Empty); // **** 508 Compliance ***
									this._okProductCode = true;
								}
								else
									throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("Product Code").ResString);
							}
							else
							{
								this._labelBloodUnit.BloodProductGuid = selectedBP;
								this._labelBloodUnit.ProductCode = this.txtProductCode.Text;
								this._labelBloodUnit.ProductShortName = this._verifyBloodUnit.ProductShortName;
								this.errError.SetVbecsError(this.txtProductCode, string.Empty); // **** 508 Compliance ***
								this._okProductCode = true;
							}
						}
					}
					else
					{
						throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("Product Code").ResString);
					}
				}
			}
			catch(BOL.BusinessObjectException err)
			{
				this._okProductCode = false;
				this._labelBloodUnit.BloodProductGuid = System.Guid.Empty;
				this._labelBloodUnit.ProductCode = string.Empty;
				this._labelBloodUnit.ProductShortName = string.Empty;
				this.errError.SetVbecsError(this.txtProductCode, err.Message); // **** 508 Compliance ***
			}
			finally
			{
				CheckValid();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// ABO/Rh combo box leave event handler, verifies entry against VerifyBloodUnit
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbABORh_Leave(object sender, System.EventArgs e)
		{
			try
			{
				if (this._labelBloodUnit.BloodUnitMedia.AboRh.Abo == this.cmbABORh.Abo &&
					this._labelBloodUnit.BloodUnitMedia.AboRh.RH == this.cmbABORh.RH && this.cmbABORh.AboRHValid)
				{
					this._okAboRh = true;
				}

				if (this.cmbABORh.Text == string.Empty)
				{
					this._okAboRh = false;
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementNotEntered("ABO/Rh"));

				}
				else
				{
					this._labelBloodUnit.BloodUnitMedia.AboRh.Abo = this.cmbABORh.Abo;
					this._labelBloodUnit.BloodUnitMedia.AboRh.RH = this.cmbABORh.RH;

					if ((this.cmbABORh.SelectedIndex<0) || (this._labelBloodUnit.BloodUnitMedia.AboRh.AboRHText == this._verifyBloodUnit.BloodUnitMedia.AboRh.AboRHText))
					{
						this._okAboRh = true;
						this.errError.SetVbecsError(this.cmbABORh, string.Empty); // **** 508 Compliance ***
					}
					else
					{
						this._okAboRh = false;
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("ABO/Rh"));
						this.errError.SetVbecsError(this.cmbABORh, Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("ABO/Rh").ResString); // **** 508 Compliance ***
					}
				}
			}
			catch(Exception err)
			{
				this._okAboRh = false;
				this.errError.SetVbecsError(this.cmbABORh, err.Message); // **** 508 Compliance ***
			}
			finally
			{
				this.CheckValid();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Expiration date time picker leave event handler, verifies entry against VerifyBloodUnit
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void dtpExpirationDate_Leave(object sender, System.EventArgs e)
		{
			try
			{
				if (this.dtpExpirationDate.VisibleText == string.Empty)
				{
					this._okExpirationDate = false;
					GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementNotEntered("Expiration Date"));
				}
				else
				{
					if (DatesMatch(this._labelBloodUnit.BloodUnitMedia.UnitExpirationDate, this.dtpExpirationDate.Value))
					{
						this._okExpirationDate = true;
					}
					else

					{
						this._labelBloodUnit.BloodUnitMedia.UnitExpirationDate = this.dtpExpirationDate.Value;

						if (DatesMatch(this._labelBloodUnit.BloodUnitMedia.UnitExpirationDate, this._verifyBloodUnit.BloodUnitMedia.UnitExpirationDate))
						{
							this._okExpirationDate = true; 
							this.errError.SetVbecsError(this.dtpExpirationDate, string.Empty); // **** 508 Compliance ***
						}
						else
						{
							this._okExpirationDate = false;
							GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("Expiration Date"));
							this.errError.SetVbecsError(this.dtpExpirationDate, Common.StrRes.ValidMsg.UC026.BR29VerifyLabelElementFailed("Expiration Date").ResString); // **** 508 Compliance ***
						}
					}
				}
			}
			catch(Exception err)
			{
				this._okExpirationDate = false;
				this.errError.SetVbecsError(this.dtpExpirationDate, err.Message); // **** 508 Compliance ***
			}
			finally
			{
				CheckValid();
			}
		}

		/// <summary>
		/// Checks Date/Time - without taking seconds into account
		/// </summary>
		/// <param name="date1"></param>
		/// <param name="date2"></param>
		/// <returns></returns>
		private bool DatesMatch(System.DateTime date1, System.DateTime date2)
		{
			//Doing things this way, because we need to omit SECONDS from TIME COMPARISONS!!!
			System.DateTime checkUnit = new DateTime(date1.Year, date1.Month, date1.Day, date1.Hour, date1.Minute, 0);
			System.DateTime checkVerify = new DateTime(date2.Year, date2.Month, date2.Day, date2.Hour, date2.Minute, 0);
				
			return(checkUnit == checkVerify);
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event, closes dialog with OK result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			GenerateExceptions(false);
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Cancel button click event, closes dialog with Cancel result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR29VerifyLabelInvalid());

			GenerateExceptions(true);
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Comment text box change event handler, enables cancel button when text is entered
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			this.btnCancel.EnabledButton = (this.txtComment.Text.Trim().Length>0);
			if(this.btnCancel.EnabledButton)
				this.btnCancel.SetToolTip(Common.StrRes.Tooltips.UC026.CancelVerification().ResString);
			else
				this.btnCancel.SetToolTip(Common.StrRes.Tooltips.UC026.EnterAComment().ResString);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgVerifyModifiedUnit_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion
	}
}

